import json

def merge_json_files_to_custom_array(input_files, output_file, unique_key, fields):
    merged_data = {}
    
    # Load and merge data from input files
    for file in input_files:
        with open(file, 'r', encoding='utf-8') as f:
            data = json.load(f)
            for item in data:
                key = item.get(unique_key)
                if key:  # Ensure the key exists
                    merged_data[key] = item
    
    # Create the custom array
    custom_array = []
    for item in merged_data.values():
        custom_entry = [item.get(field, None) for field in fields]
        custom_array.append(custom_entry)
    
    # Write custom array to the output file
    with open(output_file, 'w', encoding='utf-8') as f:
        json.dump(custom_array, f, ensure_ascii=False, indent=4)
    print(f"Merge completed. Custom array saved to {output_file}, length: {len(custom_array)}")

# Define your input files, output file, unique key, and desired fields
input_files = ["perfumeria/rol_empty.json", "gourmet/rol_empty.json", "cava/rol_empty.json", "marca_propia/rol_empty.json", "everything_adb/rol_empty.json", "abarrotes_new_full/rol_empty.json"]
#input_files
output_file = "array/master_zero_every_section.json"
unique_key = "codigoBarras"  # Replace with the unique key in your JSON
fields = ["seccion_numero", "codigoBarras", "categoria_real", "proveedor_num", "pasillo", "pedir", "proveedor_num"]  # Desired fields

# Run the function

merge_json_files_to_custom_array(input_files, output_file, unique_key, fields)
