<?php
date_default_timezone_set("America/Monterrey");
// Set the directory you want to read
$directory = isset($_GET['dir']) ? $_GET['dir'] : '.';

// Make sure the directory exists
if (!is_dir($directory)) {
    die("Directory not found.");
}

// Create an array to hold directory contents
$entries = [];

// Open the directory
$dirHandle = opendir($directory);

if ($dirHandle) {
    // Loop through the directory contents and store them in an array
    while (($entry = readdir($dirHandle)) !== false) {
        if ($entry == "." || $entry == "..") {
            continue;
        }
        
        $entryPath = $directory . DIRECTORY_SEPARATOR . $entry;
        $isDir = is_dir($entryPath);
        $size = $isDir ? '-' : filesize($entryPath); // Use filesize for files, and '-' for directories
        
        $entries[] = [
            'name' => $entry,
            'path' => $entryPath,
            'created' => filectime($entryPath),
            'modified' => filemtime($entryPath),
            'size' => $size,
            'is_dir' => $isDir
        ];
    }
    
    // Close the directory handle
    closedir($dirHandle);

    // Sort the array by the 'modified' key, descending order (latest first)
    usort($entries, function($a, $b) {
        return $b['modified'] - $a['modified'];
    });

    // Display the sorted entries
    echo "<h1>Listing of $directory</h1>";
    echo "<br>Size: ". count($entries);
	echo "<br>To root: <a href='dir.php'>Root</a>";
    echo "<ul>";
    
    foreach ($entries as $entry) {
        $entryUrl = htmlspecialchars($entry['path']);
        $created = date("Y-m-d H:i:s", $entry['created']);
        $modified = date("Y-m-d H:i:s", $entry['modified']);
        $size = $entry['is_dir'] ? '-' : $entry['size'] . ' bytes'; // Show size in bytes for files
        
        if ($entry['is_dir']) {
            echo "<li><a href=\"?dir=" . urlencode($entry['path']) . "\">[DIR] {$entry['name']}</a> - Created: $created, Modified: $modified, Size: $size</li>";
        } else {
            echo "<li><a href=\"$entryUrl\">{$entry['name']}</a> - Created: $created, Modified: $modified, Size: $size</li>";
        }
    }
    
    echo "</ul>";
} else {
    echo "Unable to read directory.";
}
?>

