<!DOCTYPE html>
<html>
  <head>
    <style>
    img {

        
      }
    .div_container{
      #border-bottom:1px lightgray;
    }
    .hide {
      display:none !important;
    }
    table {display:none}
    #barcodes, #barcodes_blocked {
      display:grid;
      justify-content:center;
    }
    #hidden_frames{
      display:hidden;
      position:absolute;
      top:-100dvh;
      left: -100dvw;
    }
    </style>
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
  </head>
  <body>

<table>
</table>
<p><h1>Conteo Codigos de Barras: <span id="count_all">0</span></h2></p>
<p><textarea id="barcodes_data"></textarea></p>
<p><button type="button" onclick="gen()">Generar codigo de barras</button></p>
<p><input type="checkbox" id="with_data" />Extra data</p>
<div id="barcodes"></div>
<div id="hidden_frames"></div>
 <script>
  function gen(){
    document.querySelector("#barcodes").innerHTML = "";
    let needs_data = false; // document.querySelector("#with_data").checked;
    let old = document.querySelector("#barcodes_data").value.split("\n")
    let list =[];
    for(let i =0;i<old.length; i++){     
      if(old[i] != "" || old[i].length > 0){
        list.push(old[i])
      }
    }
    if(needs_data){
      generate_data(list);
       return;
    }
    load_images(list);
  }
  
  let latest_data = [];
  
  function generate_data(list, index = 0){
    let url = "generate_data.php?barcode="
    let frame_set = document.querySelector("#hidden_frames");
    for(let i =0;i<list.length; i++){
      let frame = document.createElement("iframe");
      frame.src = url+list[i];
      frame_set.appendChild(frame);
    }
  }
  window.addEventListener("message", (event) => {
    let list = document.querySelector("#barcodes_data").value.split("\n")
    let count = 0;
    for(let i =0;i<list.length;i++){
      if(list[i] != "" || list[i].length > 0){
        count++;
      }
    }
    let data = event.data
    latest_data.push(data);
    console.log(count);
    if(latest_data.length == count){
      load_images(latest_data);
    }
  });
  
  function load_images(list, isBlocked = false){
    document.querySelector("#barcodes").classList.remove("hide");
    document.querySelector("#barcodes").innerHTML = "";
    document.querySelector("#count_all").textContent = list.length;
    document.querySelector("table").innerHTML = "";
    for(let i =0;i<list.length;i++){
      let code = list[i]?.codigoBarras ? list[i].codigoBarras.toString() : list[i];

      let img = document.createElement("img")

      let span = document.createElement("div");
      let text = document.createElement("span");
      img.classList.add("barcode_img");
      img.id = 'img_zero_'+i;
      let format = "auto";
      if(code.length < 13){
        let curr_len = code.length;
        while(code.length < 13){
         code = "0" + code; 
        }
      };
      span.id = "id_"+code.toString();
      span.classList.add("div_container");
      span.appendChild(img);
      span.style.cssText = `width: fit-content; scale:1.6; padding-bottom: 8rem;`;
      text.textContent = code
      text.style.cssText = `justify-content: center; display: flex;`
      span.appendChild(text);
      document.querySelector("#barcodes").appendChild(span);
      img.setAttribute("jsbarcode-value", code.toString());
      img.setAttribute("jsbarcode-format", format);
      img.setAttribute("jsbarcode-textmargin", "0");
      img.setAttribute("jsbarcode-fontoptions", "bold");
      span.addEventListener("click", (ev) =>{
        document.querySelector("#count_all").textContent = Number(document.querySelector("#count_all").textContent) - 1;
        span.remove()
      });
      document.querySelector("#barcodes").appendChild(span);
    }
    JsBarcode(".barcode_img").init();
  }

</script>
  </body>
</html>
