import json
import os
from openpyxl import Workbook, load_workbook
from datetime import datetime
import argparse
import glob
parser = argparse.ArgumentParser()
parser.add_argument('-f', '--file', help='The file to make custom')
parser.add_argument('-o', '--output', help='The output to make custom')
parser.add_argument('-s', '--specific', help='The output to make custom')
parser.add_argument('-t', '--basedir', help='The output to make custom')
parser.add_argument('-ss', '--superspecific', help='The output to make custom')
args = parser.parse_args()
arg_val = args.file
out_val = args.output
specific_val = args.specific
superspecific_val = args.superspecific
basedir = args.basedir or ""
STOP_WHILE = False


# Example Usage
input_json_file = "result.json"  # Path to your JSON file
headers_file = "headers.json"  # Path to your headers JSON file
prefix_file = ""
if arg_val:
  input_json_file = f"{arg_val}.json"
if out_val:
  headers_file = f"{out_val}.json"
if specific_val:
  prefix_file = specific_val
def flatten_json(data, prefix=''):
    """Flatten the JSON data, allowing nested keys."""
    items = {}
    if isinstance(data, dict):
        for key, value in data.items():
            new_key = f"{prefix}{key}" if prefix == '' else f"{prefix}.{key}"
            if isinstance(value, (dict, list)):
                items.update(flatten_json(value, new_key))
            else:
                items[new_key] = value
    elif isinstance(data, list):
        for item in data:
            items.update(flatten_json(item, prefix))
    return items

def get_date_str():
    """Returns the current date in 'dd-mm-YYYY' format."""
    return datetime.now().strftime('%d_%m_%Y')

def save_checkpoint(start_index, end_index):
    """Saves the current start and end index to a checkpoint file."""
    with open('checkpoint.txt', 'w') as f:
        f.write(f"{start_index}\n")
        f.write(f"{end_index}\n")

def load_checkpoint(start_default=0, end_default=500):
    """Loads the start and end index from the checkpoint file."""
    if os.path.exists('checkpoint.txt'):
        with open('checkpoint.txt', 'r') as f:
            start_index = int(f.readline().strip())
            end_index = int(f.readline().strip())
            if start_index < 0 or end_index < 0:
                return start_default, end_default
            return start_index, end_index
    return start_default, end_default  # Default to starting from 0 and ending at 500

def read_desired_headers(headers_file):
    """Reads desired headers from a JSON file."""
    if not os.path.exists(headers_file):
        raise FileNotFoundError(f"The headers file '{headers_file}' does not exist.")

    with open(headers_file, 'r') as file:
        headers = json.load(file)

    if not headers:
        raise ValueError("The headers file is empty.")

    return headers

def process_json_with_key_indexes(input_json_file, headers_file, start_index=0, end_index=500):
    if not input_json_file or not headers_file:
        raise ValueError("Input or output file path or headers file path is empty. Please provide valid paths.")

    # Generate output file name with current date
    current_date_str = get_date_str()
    current_path = os.getcwd()
    current_dir_path = os.path.basename(current_path)
    parent = os.path.dirname(current_path)
    output_excel_file = f"{current_dir_path}_{prefix_file}{current_date_str}.xlsx"
    if globals()["superspecific_val"]:
      superspecific_val_used = globals()["superspecific_val"]
      output_excel_file = f"{superspecific_val_used}.xlsx"
    if globals()["specific_val"]:
      specific_val_used = globals()["specific_val"]
      output_excel_file = f"{specific_val_used}_{current_date_str}.xlsx"
    if globals()["basedir"]:
      bdir = globals()["basedir"]
      current_date_str = get_date_str()
      current_path = os.getcwd()
      current_dir_path = os.path.basename(f"{current_path}/{bdir}")
      output_excel_file = f"{current_dir_path}/{bdir}_{prefix_file}{current_date_str}.xlsx"
    # Check if the input JSON file exists
    if not os.path.exists(input_json_file):
        raise FileNotFoundError(f"The input JSON file '{input_json_file}' does not exist.")

    # Read desired headers from the file
    desired_headers = read_desired_headers(headers_file)

    # Load checkpoint
    saved_start_index, saved_end_index = load_checkpoint()

    # Use saved start and end indexes if they exist
    start_index = saved_start_index
    end_index = saved_end_index

    if start_index == 0:
        if os.path.exists(output_excel_file):
            os.remove(output_excel_file)

    print(f"Input JSON file: {input_json_file}")
    print(f"Output Excel file: {output_excel_file}")
    print(f"Headers file: {headers_file}")
    print(f"Start Index: {start_index}")

    if start_index < 0:
        globals()["STOP_WHILE"] = True
        if os.path.exists("checkpoint.txt"):
            os.remove("checkpoint.txt")
    # Open the JSON file
    with open(input_json_file, 'r') as file:
        json_data = json.load(file)

    # Check if json_data is a list
    if not isinstance(json_data, list):
        raise ValueError("Expected JSON data to be a list of dictionaries.")

    # Create or load the workbook
    if os.path.exists(output_excel_file):
        wb = load_workbook(output_excel_file)
        ws = wb.active
        existing_headers = [cell.value for cell in ws[1]]
    else:
        wb = Workbook()
        ws = wb.active
        existing_headers = []  # Initialize empty headers for new file

    # Flatten JSON data
    flattened_data_list = [flatten_json(item) for item in json_data]

    # Prepare headers and remove prefixes
    headers_without_prefix = {key.split('.', 1)[-1]: value for key, value in desired_headers.items()}

    # Write headers only if they are not already present
    if not existing_headers:  # Only write headers if it's a new file
        ws.append(list(headers_without_prefix.values()))  # Write desired headers

    # Process data in the specified range
    end_index = min(end_index, len(json_data))

    # Determine the starting row for data insertion
    start_row = ws.max_row + 1  # Start appending data after the last existing row
    def convert_to_float(item, key):
      new_data = item.get(key, 0)
      if new_data == "N/A":
        new_data = float(0)
      return new_data
    def return_data(item, desired_headers):
      data = []
      for key in desired_headers.keys():
        if(key == "codigoBarras"):
          data.append(str(item.get(key, '')) )
        elif(key == "diasFaltantesConsiderandoStock"):
          data.append(convert_to_float(item, key ))
        elif(key == "piezasFaltantesConsiderandoStock"):
          data.append(convert_to_float(item, key ))
        elif(key == "diasFaltantesConsiderandoStockTransito"):
          data.append(convert_to_float(item, key ))
        elif(key == "piezasFaltantesConsiderandoStockTransito"):
          data.append(convert_to_float(item, key ))
        else:
          data.append(item.get(key, ''))
      return data
    for i in range(start_index, end_index):
        item = flattened_data_list[i]

        # Prepare a row with data matching the desired headers
        row = return_data(item, desired_headers)
        ws.append(row)  # Append data row

        if i >= len(json_data):
            print(f"Reached end of JSON data at index {i}.")
            STOP_WHILE = True
                
    # Save progress
    next_start_index = end_index
    next_end_index = next_start_index + (end_index - start_index)
    save_checkpoint(next_start_index, next_end_index)
                       
    # Save the workbook

    wb.save(output_excel_file)
    print(f"Excel file created: {output_excel_file}, start {next_start_index} end {next_end_index}")
    if next_start_index < 0:
        globals()["STOP_WHILE"]= True
        os.remove("checkpoint.txt")
    if next_end_index < 0:
        globals()["STOP_WHILE"] = True
        os.remove("checkpoint.txt")
    if next_start_index == next_end_index:
        globals()["STOP_WHILE"] = True
        print("STOPPING WHILE LOOP")
        target_folder = f"{parent}/results_{current_dir_path}"
        if os.path.isdir(target_folder):
            files = glob.glob(f"{target_folder}/*.json")
            for f in files:
                os.remove(f)
            print("REMOVED RESULTS FILES")
        else:
            print("Folder not found:", target_folder)
            
        if os.path.exists("checkpoint.txt"):
            os.remove("checkpoint.txt")
        return
    

# Process JSON data with key indexes
while not STOP_WHILE:
    print(f"STOP_WHILE is: {STOP_WHILE}")
    process_json_with_key_indexes(input_json_file, headers_file, start_index=0)
