#!/bin/bash

day=$(date +%d)
month=$(date +%m)
year=$(date +%Y)

#python3 everything.py -f=everything_adb -o=13 -r=1
python3 everything.py -f=abarrotes_new_full -o=13  -r=1
python3 everything.py -f=perecederos -o=13 -r=1
python3 everything.py -f=perfumeria -o=13 -r=1
python3 everything.py -f=perfu_bebes -o=13 -r=1
#python3 everything.py -f=marca_propia -o=13 -r=1
#python3 everything.py -f=cava -o=10 -r=1
#python3 everything.py -f=gourmet -o=10 -r=1
#python3 everything.py -f=abarrotes_zero -r=1
#python3 everything.py -f=perfumeria_zero -r=1

cd cava
cp ../gen.py .
cp ../headers.json .

python3 gen.py -ss=cava_${day}_${month}_${year}
python3 gen.py -f=inv_cap -s=inv_cap_
python3 gen.py -f=no_venta -s=no_venta_
cd ..

cd perecederos
cp ../gen.py .
cp ../headers.json .
python3 gen.py -ss=perecederos_${day}_${month}_${year}
python3 gen.py -f=inv_cap -s=inv_cap_
python3 gen.py -f=no_venta -s=no_venta_
cd ..

cd gourmet
cp ../gen.py .
cp ../headers.json .
python3 gen.py -ss=gourmet_${day}_${month}_${year}
python3 gen.py -f=inv_cap -s=inv_cap_
python3 gen.py -f=no_venta -s=no_venta_
cd ..

cd perfumeria
cp ../gen.py .
cp ../headers.json .
python3 gen.py -ss=perfumeria_${day}_${month}_${year}
python3 gen.py -f=inv_cap -s=inv_cap_
python3 gen.py -f=no_venta -s=no_venta_
cd ..

cd marca_propia
cp ../gen.py .
cp ../headers.json .
python3 gen.py -ss=marca_propia_${day}_${month}_${year}
python3 gen.py -f=inv_cap -s=inv_cap_
python3 gen.py -f=no_venta -s=no_venta_
cd ..

#cd everything_adb
cd abarrotes_new_full
cp ../gen.py .
cp ../headers.json .
python3 gen.py
python3 gen.py -f=negatives -s=negatives_
python3 gen.py -f=pd -s=pedido_
python3 gen.py -f=inv_cap -s=inv_cap_
python3 gen.py -f=no_venta -s=no_venta_
cd ..

python3 _.py
python3 make_master.py -f=abarrotes_new_full/result.json -tf=${day}/${month}/${year} -data=1 -o=result.json

cp __.py ${day}_${month}_${year}/__.py && cp gen.py ${day}_${month}_${year}/gen.py && cp headers.json ${day}_${month}_${year}/headers.json

cd ${day}_${month}_${year}

python3 gen.py -f=result_data -ss=output

cd ..

#python3 make_master.py -f=everything_adb/result.json -i=1 --data=1 -o=everything_inv_one/result
#python3 iniciar_empty.py -r=1

#python3 everything.py -f=new_items -r=1
cd new_items
cp ../gen.py .
cp ../headers.json .
python3 gen.py
cd ..
